------------------------------------------------------------------------------
-- Auto Resize Effect Mask
--
-- $Revision$
--
-- This script adds an InTool Script to a tool that will resize its effect mask
-- to the size of the Input, or the size of the tool if it's an internal creator.
-- This is useful for things like Bitmap Masks
--
-- written by : Sean Konrad (sean@eyeonline.com
--              March 08, 2006
------------------------------------------------------------------------------

-- turn the function into a string literal so we can easily pass it into the FrameRenderScript input (a string value)
functionToPass = [[
-- first, check to see if the Resize function has been initialized.
-- will only be initialized if there's an associated mask image.

-- the way intool scripts work is that any of the tool's inputs can be referred to without the 
-- use of a tool object beforehand.
-- so for example, we check to see if the EffectMask has the resize function by simply typing this:
if EffectMask.Resize then
	
	-- If there's an input, we use that to determine the size to which we will resize the effect mask.
	if Input then
		
		-- set up the rszWidth and rszHeight variables to equal that of the
		-- input's width and height, syntax below:
		rszHeight = Input.Height
		rszWidth = Input.Width
	else
	
		-- if there's no input, it's a creator, meaning that we need to 
		-- base this on the size of the Width or Height slider.
		-- if it has such an input...
		
		if Width then
			rszWidth = Width
			rszHeight = Height
		else
		
			-- if it doesn't, then it's likely a loader
			-- you could mask a loader with this method if you connected it 
			-- to the GarbageMatte input, and made the adjustment accordingly.
			print("Cannot Auto Resize Effect Mask")
		end
	end
	
	-- if the variable was initialized...
	if rszWidth then
		-- Set the EffectMask according to the rszWidth/rszHeight variables
		-- using the Resize function..
		
		EffectMask = EffectMask:Resize(nil, { RSZ_Width = rszWidth, RSZ_Height = rszHeight, RSZ_Filter = "CatmulRom"})
	end
end
]]

if tool then
	tool.FrameRenderScript = tool.FrameRenderScript[0].."\n\n\n -- FUNCTION GENERATED BY AUTO RESIZE EFFECT MASK SCRIPT \n\n"..functionToPass
else
	print("ERROR: This script is a tool script.")
end
